/***************************************************************
   MODERN HTML FORMATTER - COMPLETE OUTPUT
   Includes all 14 sections + NEW Vocational Guidance
****************************************************************/
window.formatPEPOutputModern = function(profile) {
  if (profile.error) {
    return `<div class="pep-error">${profile.error}</div>`;
  }
  
  const arch = profile.archetype;
  const compat = ARCHETYPE_COMPATIBILITY[profile.archetypeName] || {};
  const shadow = SHADOW_WORK[profile.archetypeName] || {};
  const integration = generateIntegration(profile);
  const vocationalGuidance = generateVocationalGuidance(profile);
  
  // Build birth time/zone display if provided
  const timeDisplay = profile.birthTime ? profile.birthTime : 'Not provided';
  const zoneDisplay = profile.birthZone ? profile.birthZone : 'Not provided';
  
  let html = `
<div class="pep-profile-modern">
  <div class="pep-title-block">
    <h1>Your Purposed Path</h1>
    <div class="pep-subtitle">Harmonic Vocational Blueprint</div>
    <div class="pep-soul-name">${profile.soulName}</div>
  </div>
  
  <div class="pep-identity-block">
    <div class="pep-id-grid">
      <div class="pep-id-item">
        <div class="pep-id-label">Identity Coordinate (CNID)</div>
        <div class="pep-id-value">${profile.cnid}</div>
      </div>
      <div class="pep-id-item">
        <div class="pep-id-label">Harmonic Position</div>
        <div class="pep-id-value">#${profile.harmonicId} of 4,122</div>
      </div>
    </div>
    
    <div class="pep-coordinate-grid">
      <div class="pep-coord-item">
        <span class="pep-coord-label">Turtle Day:</span>
        <span class="pep-coord-value">${profile.turtleDay}/364</span>
      </div>
      <div class="pep-coord-item">
        <span class="pep-coord-label">THD Phase:</span>
        <span class="pep-coord-value">${profile.thdPhase} (${profile.thdData.name})</span>
      </div>
      <div class="pep-coord-item">
        <span class="pep-coord-label">Scalar Mode:</span>
        <span class="pep-coord-value">${profile.scalarMod}</span>
      </div>
    </div>
    
    <div class="pep-birth-verification" style="background:#fff; padding:15px; border-radius:8px; margin-bottom:20px; font-size:0.85em;">
      <div class="pep-section-label" style="margin-bottom:10px;">Birth Data Verification</div>
      <div style="display:grid; grid-template-columns: repeat(2, 1fr); gap:8px;">
        <div><strong>Name:</strong> ${profile.birthName}</div>
        <div><strong>Date:</strong> ${profile.birthDate}</div>
        <div><strong>Location:</strong> ${profile.birthLocation}</div>
        <div><strong>Time:</strong> ${timeDisplay}</div>
        <div><strong>Zone:</strong> ${zoneDisplay}</div>
        <div style="grid-column: span 2; word-break: break-all;"><strong>Seed Hash:</strong> <span style="font-family:monospace; font-size:0.85em;">${profile.seedHash}</span></div>
      </div>
    </div>
    
    <div class="pep-soul-decode">
      <div class="pep-section-label">Pattern Signature</div>
      <div class="pep-phoneme-grid">
        ${profile.soulBreakdown.map(b => `<div class="pep-phoneme">${b}</div>`).join('')}
      </div>
      <div class="pep-soul-summary">${profile.soulSummary}</div>
    </div>
  </div>
  
  ${profile.hourQuadrantData ? `
  <!-- HOUR QUADRANT - Birth Time Coherence Modulation -->
  <div class="pep-layer-divider" style="background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);">
    <div class="pep-layer-title">🕐 BIRTH TIME MODULATION</div>
    <div class="pep-layer-desc">How your hour of birth shapes your archetype expression</div>
  </div>
  
  <section class="pep-section" style="background: linear-gradient(180deg, #f8f9ff 0%, #fff 100%);">
    <h2>${profile.hourQuadrantData.name}</h2>
    <div class="pep-subtitle" style="text-align:center; margin-bottom:20px; color:#666;">${profile.hourQuadrantData.hours}</div>
    
    <div class="pep-quadrant-grid" style="display:grid; gap:20px;">
      <div class="pep-quadrant-block" style="background:#fff; padding:20px; border-radius:12px; border-left:4px solid #6366f1;">
        <h3 style="margin-top:0; color:#6366f1;">Core Modulation</h3>
        <p>${profile.hourQuadrantData.coreModulation}</p>
      </div>
      
      <div class="pep-quadrant-block" style="background:#fff; padding:20px; border-radius:12px; border-left:4px solid #8b5cf6;">
        <h3 style="margin-top:0; color:#8b5cf6;">Cognitive Shift</h3>
        <p>${profile.hourQuadrantData.cognitiveShift}</p>
      </div>
      
      <div class="pep-quadrant-block" style="background:#fff; padding:20px; border-radius:12px; border-left:4px solid #f59e0b;">
        <h3 style="margin-top:0; color:#f59e0b;">Glitch Manifestation</h3>
        <p>${profile.hourQuadrantData.glitchManifestation}</p>
      </div>
      
      <div class="pep-quadrant-block" style="background:#fff; padding:20px; border-radius:12px; border-left:4px solid #10b981;">
        <h3 style="margin-top:0; color:#10b981;">Vocational Approach</h3>
        <p>${profile.hourQuadrantData.vocationalApproach}</p>
      </div>
      
      <div class="pep-quadrant-block" style="background:#fff; padding:20px; border-radius:12px; border-left:4px solid #ec4899;">
        <h3 style="margin-top:0; color:#ec4899;">Relationship Style</h3>
        <p>${profile.hourQuadrantData.relationshipStyle}</p>
      </div>
      
      <div class="pep-quadrant-block" style="background:#fff; padding:20px; border-radius:12px; border-left:4px solid #06b6d4;">
        <h3 style="margin-top:0; color:#06b6d4;">Ritual Timing</h3>
        <p>${profile.hourQuadrantData.ritualTiming}</p>
      </div>
      
      <div class="pep-quadrant-integration" style="background:linear-gradient(135deg, #1a1a2e 0%, #16213e 100%); color:#fff; padding:25px; border-radius:12px; margin-top:10px;">
        <h3 style="margin-top:0; color:#a5b4fc;">Integration Path</h3>
        <p style="margin-bottom:0; line-height:1.7;">${profile.hourQuadrantData.integration}</p>
      </div>
    </div>
  </section>
  ` : `
  <!-- No birth time provided - show notice -->
  <div class="pep-layer-divider" style="background: #6b7280;">
    <div class="pep-layer-title">🕐 BIRTH TIME MODULATION</div>
    <div class="pep-layer-desc">Birth time not provided</div>
  </div>
  
  <section class="pep-section" style="background:#f9fafb; text-align:center; padding:40px;">
    <p style="color:#6b7280; font-style:italic;">Birth time was not provided. The Hour Quadrant modulation shows how your specific hour of birth shapes how your archetype expresses—affecting your cognitive rhythm, glitch patterns, vocational approach, relationship style, and optimal ritual timing.</p>
    <p style="color:#6b7280;">To receive this analysis, regenerate your profile with your birth time included.</p>
  </section>
  `}
  
  <!-- VOCATIONAL GUIDANCE SECTION -->
  <div class="pep-layer-divider pep-voc-divider">
    <div class="pep-layer-title">💼 VOCATIONAL GUIDANCE</div>
    <div class="pep-layer-desc">Your purposed path based on harmonic design</div>
  </div>
  
  <section class="pep-section pep-voc-section">
    <h2>YOUR PURPOSED PATH</h2>
    <div class="pep-voc-content">
      ${vocationalGuidance}
    </div>
  </section>
  
  <div class="pep-layer-divider">
    <div class="pep-layer-title">STABLE TRAIT ARCHITECTURE</div>
    <div class="pep-layer-desc">Your permanent energetic fingerprint</div>
  </div>
  
  <section class="pep-section">
    <h2>I. PRIMARY FUNCTION</h2>
    <div class="pep-archetype-title">${profile.archetypeName}</div>
    <div class="pep-contract-block">
      <div class="pep-contract-label">Core Pattern</div>
      <p>${arch.contract}</p>
    </div>
    <div class="pep-contract-block">
      <div class="pep-contract-label">Secondary Pattern</div>
      <p>${profile.lpData.title} — ${profile.lpData.desc}</p>
    </div>
  </section>
  
  <section class="pep-section">
    <h2>II. COGNITIVE ARCHITECTURE</h2>
    <table class="pep-table-modern">
      <thead>
        <tr>
          <th>Component</th>
          <th>Pattern</th>
          <th>Function</th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td>Input</td>
          <td>${arch.gid_in}</td>
          <td>${arch.gid_in_d}</td>
        </tr>
        <tr>
          <td>Processing</td>
          <td>${arch.gid_proc}</td>
          <td>${arch.gid_proc_d}</td>
        </tr>
        <tr>
          <td>Decision</td>
          <td>${arch.gid_dec}</td>
          <td>${arch.gid_dec_d}</td>
        </tr>
        <tr>
          <td>Output</td>
          <td>${arch.gid_out}</td>
          <td>${arch.gid_out_d}</td>
        </tr>
      </tbody>
    </table>
  </section>
  
  <section class="pep-section">
    <h2>III. NUMEROLOGICAL STRUCTURE</h2>
    <div class="pep-num-grid">
      <div class="pep-num-item">
        <div class="pep-num-label">Life Path ${profile.lifePath}</div>
        <div class="pep-num-title">${profile.lpData.title}</div>
        <div class="pep-num-desc">${profile.lpData.desc}</div>
      </div>
      <div class="pep-num-item">
        <div class="pep-num-label">Expression ${profile.expr}</div>
        <div class="pep-num-title">${profile.exData.title}</div>
        <div class="pep-num-desc">${profile.exData.desc}</div>
      </div>
      <div class="pep-num-item">
        <div class="pep-num-label">Soul Urge ${profile.soul}</div>
        <div class="pep-num-title">${profile.suData.title}</div>
        <div class="pep-num-desc">${profile.suData.desc}</div>
      </div>
    </div>
  </section>
  
  <section class="pep-section">
    <h2>IV. FRICTION ANALYSIS</h2>
    <div class="pep-friction-block">
      <div class="pep-friction-title">Pattern: ${arch.glitch_name}</div>
      <div class="pep-friction-item">
        <div class="pep-friction-label">Surface Symptom</div>
        <p>${arch.glitch_desc}</p>
      </div>
      <div class="pep-friction-item">
        <div class="pep-friction-label">Immediate Fix</div>
        <p>${arch.glitch_fix}</p>
      </div>
      ${shadow.deep ? `
      <div class="pep-friction-item pep-shadow-deep">
        <div class="pep-friction-label">Deep Shadow Pattern</div>
        <p>${shadow.deep}</p>
      </div>
      <div class="pep-friction-item pep-shadow-integration">
        <div class="pep-friction-label">Integration Path</div>
        <p>${shadow.integration}</p>
      </div>
      ` : ''}
    </div>
  </section>
  
  <section class="pep-section">
    <h2>V. RELATIONAL DYNAMICS</h2>
    <div class="pep-rel-block">
      <div class="pep-rel-item">
        <div class="pep-rel-label">Alignment (Flow State)</div>
        <p>${arch.rel_align}</p>
      </div>
      <div class="pep-rel-item">
        <div class="pep-rel-label">Friction Points</div>
        <p>${arch.rel_chal}</p>
      </div>
    </div>
    
    ${compat.high ? `
    <div class="pep-compat-section">
      <h3>Compatibility Matrix</h3>
      <div class="pep-compat-block">
        <div class="pep-compat-tier pep-compat-high">
          <div class="pep-compat-label">High Synergy</div>
          <div class="pep-compat-archetypes">${compat.high.join(', ')}</div>
          <div class="pep-compat-desc">${compat.high_desc}</div>
        </div>
        <div class="pep-compat-tier pep-compat-med">
          <div class="pep-compat-label">Moderate Synergy</div>
          <div class="pep-compat-archetypes">${compat.med.join(', ')}</div>
          <div class="pep-compat-desc">${compat.med_desc}</div>
        </div>
        <div class="pep-compat-tier pep-compat-low">
          <div class="pep-compat-label">Challenge Dynamics</div>
          <div class="pep-compat-archetypes">${compat.low.join(', ')}</div>
          <div class="pep-compat-desc">${compat.low_desc}</div>
        </div>
      </div>
    </div>
    ` : ''}
  </section>
  
  <section class="pep-section">
    <h2>VI. RESONANCE FREQUENCIES</h2>
    <div class="pep-resonance-grid">
      <div class="pep-res-item">
        <div class="pep-res-label">Sonic</div>
        <div class="pep-res-value">${arch.freq_name}</div>
        <div class="pep-res-desc">${arch.freq_desc}</div>
      </div>
      <div class="pep-res-item">
        <div class="pep-res-label">Geometric</div>
        <div class="pep-res-value">${arch.geo_name}</div>
        <div class="pep-res-desc">${arch.geo_desc}</div>
      </div>
    </div>
  </section>
  
  <section class="pep-section">
    <h2>VII. ALIGNMENT TOOLKIT</h2>
    <div class="pep-toolkit-grid">
      <div class="pep-tool-item">
        <div class="pep-tool-label">Aromatic</div>
        <div class="pep-tool-name">${arch.oil_name}</div>
        <div class="pep-tool-desc">${arch.oil_desc}</div>
      </div>
      <div class="pep-tool-item">
        <div class="pep-tool-label">Crystal</div>
        <div class="pep-tool-name">${arch.crystal_name}</div>
        <div class="pep-tool-desc">${arch.crystal_desc}</div>
      </div>
      <div class="pep-tool-item">
        <div class="pep-tool-label">Metal</div>
        <div class="pep-tool-name">${arch.metal_name}</div>
        <div class="pep-tool-desc">${arch.metal_desc}</div>
      </div>
      <div class="pep-tool-item">
        <div class="pep-tool-label">Animal Pattern</div>
        <div class="pep-tool-name">${arch.animal_name}</div>
        <div class="pep-tool-desc">${arch.animal_desc}</div>
      </div>
      <div class="pep-tool-item">
        <div class="pep-tool-label">Audio</div>
        <div class="pep-tool-name">${arch.music_name}</div>
        <div class="pep-tool-desc">${arch.music_desc}</div>
      </div>
      <div class="pep-tool-item">
        <div class="pep-tool-label">Visual</div>
        <div class="pep-tool-name">${arch.color_name}</div>
        <div class="pep-tool-desc">${arch.color_desc}</div>
      </div>
    </div>
  </section>
  
  <section class="pep-section">
    <h2>VIII. NATIVE VOCATION</h2>
    <div class="pep-vocation">${arch.vocation}</div>
  </section>
  
  <section class="pep-section">
    <h2>IX. INTEGRATION PROTOCOL</h2>
    <div class="pep-ritual-title">${arch.ritual_name}</div>
    <ol class="pep-ritual-steps">
      ${arch.ritual_steps.map(s => `<li>${s}</li>`).join('')}
    </ol>
  </section>
  
  <section class="pep-section">
    <h2>X. SYNTHESIS</h2>
    <div class="pep-synthesis">${arch.summary_synthesis}</div>
  </section>
  
  <section class="pep-section pep-integration-section">
    <h2>XI. CROSS-COMPONENT INTEGRATION</h2>
    <div class="pep-integration-content">${integration}</div>
  </section>
  
  <div class="pep-layer-divider">
    <div class="pep-layer-title">HARMONIC ORIENTATION</div>
    <div class="pep-layer-desc">How you move through time</div>
  </div>
  
  <section class="pep-section">
    <h2>XII. THD PHASE RHYTHM</h2>
    <div class="pep-phase-header">Phase ${profile.thdPhase}: ${profile.thdData.name}</div>
    <div class="pep-phase-rhythm">${profile.thdData.rhythm}</div>
    <div class="pep-phase-block">
      <p>${profile.thdData.description}</p>
      <div class="pep-phase-grid">
        <div class="pep-phase-item">
          <div class="pep-phase-label">Strength</div>
          <div>${profile.thdData.strength}</div>
        </div>
        <div class="pep-phase-item">
          <div class="pep-phase-label">Challenge</div>
          <div>${profile.thdData.challenge}</div>
        </div>
        <div class="pep-phase-item">
          <div class="pep-phase-label">Timing Guidance</div>
          <div>${profile.thdData.timing}</div>
        </div>
      </div>
    </div>
  </section>
  
  <section class="pep-section">
    <h2>XIII. SCALAR MODULATOR</h2>
    <div class="pep-scalar-header">${profile.scalarMod} Mode</div>
    <div class="pep-scalar-posture">${profile.scalarData.posture}</div>
    <div class="pep-scalar-block">
      <p>${profile.scalarData.description}</p>
      <div class="pep-scalar-grid">
        <div class="pep-scalar-item">
          <div class="pep-scalar-label">Expression</div>
          <div>${profile.scalarData.expression}</div>
        </div>
        <div class="pep-scalar-item">
          <div class="pep-scalar-label">Shadow Pattern</div>
          <div>${profile.scalarData.shadow}</div>
        </div>
        <div class="pep-scalar-item">
          <div class="pep-scalar-label">Alignment Practice</div>
          <div>${profile.scalarData.alignment}</div>
        </div>
      </div>
    </div>
  </section>
  
  <section class="pep-section">
    <h2>XIV. HARMONIC SIGNATURE IN MOTION</h2>
    <div class="pep-motion-content">
      ${generateMotionAnalysis(profile)}
    </div>
  </section>
  
  <div class="pep-footer-modern">
    <div class="pep-footer-id">ID: #${profile.harmonicId} | Day: ${profile.turtleDay} | Phase: ${profile.thdPhase} | Mode: ${profile.scalarMod}</div>
    <div class="pep-footer-verified">Verified by PEP Computational Engine v25.1.0</div>
    <div class="pep-footer-credit">Harmonic Vocational Alignment System • CreationUnified.com</div>
  </div>
</div>
  `;
  
  return html;
};

console.log('PEP Formatter with Vocational Guidance Loaded');
